/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-2002 Parametric Technology Corporation.
	All rights reserved.
*/

//	CenterAxes.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CAssembly.h"
#include "CApplication.h"


HRESULT CenterAxes(IGeometric *pFirstGeometric, IGeometric *pSecondGeometric)
{

	//	Aligns the center of two circular edges of two components

	START_METHOD("Center Axes")

	HRESULT status=CONV_SUCCESS;
	VARIANT_BOOL bVal;
	
	IDesignInstance *ins = NULL;
	
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *pActiveDoc = NULL;
	status = pdApplication->GetActiveDoc(&pActiveDoc);
	CHECK_RETURN_STATUS(status)

	IGeometric *pTemp = NULL;
	IGeometric *geometric = CAST(IGeometric, pSecondGeometric);

	// UpdateDependencies method
	status = geometric->IsDependentOn(CAST(IGeometric,pFirstGeometric),&bVal);
	if (bVal) {
		pTemp = pFirstGeometric;
		pFirstGeometric = pSecondGeometric;
		pSecondGeometric = pTemp;
	}
	
	IObject *pIns = NULL;
	status = CAST(IObject, pFirstGeometric)->GetParent(GetBSTR("DesignInstance"),&pIns);
	CHECK_RETURN_STATUS(status)

	ICenterAxes *pMatingCondition = NULL;

	status = CAST(ICenterAxesClass2, GetCLASS(CenterAxes))->CreateCenterAxes2(pFirstGeometric, pSecondGeometric, &pMatingCondition);
	CHECK_RETURN_STATUS(status)
 		
	ins = CAST(IDesignInstance, pIns);		
	status = ins->AddMatingCondition(CAST(IMatingCondition, pMatingCondition));
	CHECK_RETURN_STATUS(status)

    END_METHOD("Center Axes") 
}
